#include "garglkini.h"

const char *garglkini =
"#===============================================================================\n"
"# Gargoyle Glk configuration\n"
"#-------------------------------------------------------------------------------\n"
"#\n"
"# Gargoyle will look for configuration files and load them in this\n"
"# order, with later settings overriding earlier settings:\n"
"#\n"
"#   1: same directory as the executable: garglk.ini (windows)\n"
"#   2: /etc/garglk.ini (or other location set at build time, Unix only)\n"
"#   3: Platform-specific locations:\n"
"#          $HOME/.garglkrc (unix)\n"
"#          ${XDG_CONFIG_HOME:-$HOME/.config}/garglk.ini (unix)\n"
"#          <user settings directory>/Gargoyle (haiku)\n"
"#          %APPDATA%/Gargoyle/garglk.ini (windows)\n"
"#          current working directory: garglk.ini (windows)\n"
"#          $HOME/garglk.ini (mac)\n"
"#   4: game directory: garglk.ini\n"
"#   5: name-of-game-file.ini (so for hell.gam it would read hell.ini)\n"
"#\n"
"# Sections of the config file can be turned on or off by matching\n"
"# either the interpreter or game file being run. See the bottom\n"
"# of this file for examples.\n"
"\n"
"# In addition to a user's specific config file, games can provide their\n"
"# own config file to overwrite some or all of a user's settings. This\n"
"# can be disabled by setting the following option to 0.\n"
"game_config   1\n"
"\n"
"scrollwidth   0               # set to 8 to make a nice scrollbar\n"
"scrollbg      b0b0b0\n"
"scrollfg      808080\n"
"\n"
"# By default, games/interpreters are allowed to change the appearance of\n"
"# Gargoyle to some degree: colors can be set, reverse video can be set, and the\n"
"# appearance of Glk styles can be changed (allowing interpreters to change what\n"
"# the style \"emphasized\" means, for example). Setting this to 0 disables this\n"
"# behavior: colors can't be used, reverse video can't be used, and stylehint\n"
"# settings are ignored. The impetus for this option was to allow users to\n"
"# disable games whose colors they found distasteful.\n"
"stylehint     1\n"
"\n"
"safeclicks    1               # set to 0 if game cancels line events properly\n"
"\n"
"cols          60              # nice good line length for reading. but...\n"
"rows          25              # see the bottom for terp-specific over-rides\n"
"\n"
"lockcols      0               # set to 1 to enforce col count\n"
"lockrows      0               # set to 1 to enforce row count\n"
"\n"
"# Gargoyle can try to restore the last window size and window location.\n"
"# This is generally only provided as a hint to the window system, and\n"
"# may be ignored. Window location restoration is not supported on macOS,\n"
"# but is supported on all other operating systems. The value is\n"
"# whitespace-delimited strings taking the value \"size\" or \"location\":\n"
"#\n"
"# save_window size\n"
"# save_window location\n"
"# save_window size location\n"
"#\n"
"# The default is to save neither. If Gargoyle is able to restore a\n"
"# saved window size, then the \"cols\" and \"rows\" settings are ignored.\n"
"\n"
"justify       0               # 0=ragged-right 1=justified\n"
"quotes        1               # Smart quotes           -- 0=off 1=normal 2=rabid\n"
"dashes        1               # Dash replacement level -- 0=off 1=-,em 2=-,en,em\n"
"spaces        1               # Spaces after full stop -- 0=off 1=one 2=two\n"
"caps          0               # Force uppercase input  -- 0=off 1=on\n"
"\n"
"graphics      1               # enable graphics\n"
"sound         1               # enable sound\n"
"\n"
"# Gargoyle provides support for the Z-Machine's sound effects 1 and 2.\n"
"# The Z-Machine Standards Document 1.1 says this about so-called bleeps:\n"
"#\n"
"# \"Number 1 is a high-pitched bleep, number 2 a low-pitched one\"\n"
"#\n"
"# Here you can define what the bleeps sound like. The syntax is this:\n"
"#\n"
"# zbleep number duration frequency\n"
"#\n"
"# number is either 1 or 2\n"
"# duration is the duration, in seconds, and can be fractional\n"
"# frequency is the pitch in Hz (440 = A5), and must be integral\n"
"#\n"
"# This creates a pure (sinusoidal) tone at the given frequency.\n"
"#\n"
"# To disable a bleep, set its duration to 0. The defaults here mimic\n"
"# Infocom's DOS interpreter. To mimic Infocom's C128 interpreter:\n"
"#\n"
"# zbleep        1 0.1 1480\n"
"# zbleep        2 0.1 660\n"
"#\n"
"# Instead of a generated tone, you can provide a file to be used as the\n"
"# bleep. This has the syntax:\n"
"#\n"
"# zbleep_file   1 /path/to/file.aiff\n"
"# zbleep_file   2 /path/to/file.aiff\n"
"#\n"
"# The file should be a Blorb-supported file (AIFF or Ogg Vorbis),\n"
"# although Gargoyle also currently supports, as extensions to Blorb, WAV\n"
"# and MP3 files.\n"
"zbleep        1 0.1 1175\n"
"zbleep        2 0.1 440\n"
"\n"
"fullscreen    0               # set to 1 for fullscreen\n"
"zoom          1.0             # set display zoom\n"
"\n"
"#===============================================================================\n"
"# Fonts, sizes and spaces\n"
"# (Tweak this if you choose other fonts, or want bigger text)\n"
"#-------------------------------------------------------------------------------\n"
"#\n"
"# The 'standard' fonts.\n"
"# Omit to use the builtin fonts, or specify a font family.\n"
"\n"
"monofont      Gargoyle Mono\n"
"monosize      12.6\n"
"\n"
"propfont      Gargoyle Serif\n"
"propsize      14.7\n"
"\n"
"wmarginx      20              # space around the window frame\n"
"wmarginy      20\n"
"wpaddingx     0               # space between windows\n"
"wpaddingy     0\n"
"wborderx      0               # border line width between windows\n"
"wbordery      0\n"
"tmarginx      7               # internal margin of text windows\n"
"tmarginy      7\n"
"\n"
"leading       20              # Also known as linespacing\n"
"baseline      15              # Offset from top of line to baseline\n"
"\n"
"# Fonts for Text Buffer windows\n"
"tfont  0      propr           # Normal\n"
"tfont  1      propi           # Emphasized\n"
"tfont  2      monor           # Preformatted\n"
"tfont  3      propb           # Header\n"
"tfont  4      propb           # Subheader\n"
"tfont  5      propz           # Alert\n"
"tfont  6      propi           # Note\n"
"tfont  7      propr           # BlockQuote\n"
"tfont  8      propb           # Input\n"
"tfont  9      propr           # User1\n"
"tfont 10      propr           # User2\n"
"\n"
"# Fonts for Text Grid windows\n"
"gfont  0      monor           # Normal\n"
"gfont  1      monoi           # Emphasized\n"
"gfont  2      monor           # Preformatted\n"
"gfont  3      monob           # Header\n"
"gfont  4      monob           # Subheader\n"
"gfont  5      monoz           # Alert\n"
"gfont  6      monoi           # Note\n"
"gfont  7      monor           # BlockQuote\n"
"gfont  8      monob           # Input\n"
"gfont  9      monor           # User1\n"
"gfont 10      monor           # User2\n"
"\n"
"# Fonts have gaps in their coverage of characters. Historically when your\n"
"# preferred font didn't support a particular character, Gargoyle rendered it as\n"
"# a question mark. Now GNU Unifont is included, and used as a fallback for\n"
"# glyphs that don't exist in the primary font. Unifont has complete coverage of\n"
"# the Basic Multilingual Plane and wide coverage of the Supplementary\n"
"# Multilingual Plane. However, it is a rather utilitarian font, so if you'd\n"
"# like to use different fonts as fallbacks, you can do so here. You can specify\n"
"# as many fallback fonts as you want, with the higher priority ones listed\n"
"# first. Unifont will still be used as a last resort.\n"
"#\n"
"# Unifont will substitute for both proportional and monospace fonts, but if you\n"
"# provide your own proportional substitute font, it will not look good in\n"
"# monospace. Therefore, when you supply your own fallback fonts, you can specify\n"
"# whether they are proportional, monospace, or both.\n"
"#\n"
"# You can specify as many fonts as you want, separated by space. First-listed\n"
"# fonts have higher priority.\n"
"#\n"
"# Font paths must be absolute: the behavior of relative paths is unspecified.\n"
"# Fonts can be OpenType, TrueType, or Type 1.\n"
"#\n"
"# The syntax is:\n"
"#\n"
"# glyph_substitution_file style /path/to/font [/path_to_font...]\n"
"#\n"
"# Where \"style\" is:\n"
"# • monor, monob, monoi, monoz, propr, propb, propi, propz\n"
"#   (monospace/proportional regular, bold, italic, bold italic)\n"
"# • mono (all monospace styles)\n"
"# • prop (all proportional styles)\n"
"# • * (both monospace and proportional styles)\n"
"#\n"
"# Gargoyle will generate, as necessary, bold and italic styles, so if there's a\n"
"# font you like, but it only has, for example, regular and bold variants:\n"
"#\n"
"# glyph_substitution_file propb /fonts/Bold.ttf\n"
"# glyph_substitution_file propz /fonts/Bold.ttf\n"
"# glyph_substitution_file prop /fonts/Regular.ttf\n"
"#\n"
"# Or if a font only has regular:\n"
"#\n"
"# glyph_substitution_file prop /fonts/Regular.ttf\n"
"#\n"
"# Remember that the first-listed font has higher priority, so list more specific\n"
"# fonts first (e.g. propr before prop, and prop before *).\n"
"\n"
"#===============================================================================\n"
"# Text LCD Filtering\n"
"#-------------------------------------------------------------------------------\n"
"#\n"
"# When using LCD subpixel rendering, the filter used (if not set otherwise) will\n"
"# be equivalent to the filter Gargoyle has always used. This looks fairly good\n"
"# without gamma correction, but might be blurrier than some people prefer.\n"
"#\n"
"# The available values for lcdfilter are:\n"
"#\n"
"#   1: none (equiv. custom filter: 0 0 255 0 0)\n"
"#      This filter looks very ugly and is not recommended. However, it is the\n"
"#      absolute sharpest, and when used with the correct gamma value on a high-\n"
"#      DPI display, can give the clearest and sharpest possible text.\n"
"#\n"
"#   2: default (equiv. custom filter: 8, 77, 86, 77, 8)\n"
"#      This is not the default filter for Gargoyle, but it is FreeType's default\n"
"#      filter for LCD rendering. It's similar to Gargoyle's, but a tad sharper,\n"
"#      and is color balanced (the values for the filter add up to 256), unlike\n"
"#      Gargoyle's filter (which add up to less than - but close to - 256, which\n"
"#      can sometimes lead to slightly pale colors when using gamma correction).\n"
"#\n"
"#   3: light (equiv. custom filter: 0 85 86 85 0)\n"
"#      This filter is color-balanced like the default one, but is as sharp as\n"
"#      possible while also attempting to eliminate color fringes caused by the\n"
"#      use of subpixel rendering. However, while using 'default' will also help\n"
"#      eliminate such color fringes while not using gamma correction (by setting\n"
"#      gamma to 1.0), this 'light' filter is less forgiving. Using 'light' is\n"
"#      generally recommended most when using the appropriate gamma correction\n"
"#      for your display.\n"
"#\n"
"#   4: legacy (no equiv. custom filter; uses different algorithm)\n"
"#      This filter is similar to 'none', but with its effect significantly toned\n"
"#      down. The result is a very sharp filter that might not be TOO noticeable.\n"
"#      However, it was designed for fully hinted text that's been snapped to the\n"
"#      pixel grid of the display, and causes severe color fringes otherwise.\n"
"#      Since Gargoyle does not use font hinting, the color fringes caused by\n"
"#      this filter can be just as noticeable as the ones caused by 'none'.\n"
"#\n"
"# If any other value is set, the custom filter is used. If one is not set, the\n"
"# custom filter will use values equivalent to how Gargoyle has filtered subpixel\n"
"# text in the past. By default, Gargoyle does not use gamma correction.\n"
"#\n"
"# When using gamma correction and LCD subpixel font rendering, it's recommended\n"
"# to set lcdfilter to either 'default' or 'light'.\n"
"#\n"
"# If you choose your own filter, it's recommended to follow the advice at the\n"
"# top of the following FreeType documentation page:\n"
"# https://www.freetype.org/freetype2/docs/reference/ft2-lcd_rendering.html\n"
"\n"
"lcd           1               # 0=grayscale 1=subpixel\n"
"lcdfilter     custom          # subpixel filter, set to 'default' if blurry\n"
"lcdweights    28 56 85 56 28  # custom filter, default is Gargoyle's own\n"
"\n"
"\n"
"#===============================================================================\n"
"# Colors and style definitions\n"
"#-------------------------------------------------------------------------------\n"
"#\n"
"# Default here is for black text on a white background.\n"
"#\n"
"# Depending on your screen you may want to tweak the gamma.\n"
"# Good values to try are 1.0, 1.8 and 2.2.\n"
"#\n"
"# There are separate colors for TextBuffer and TextGrid windows.\n"
"# TextBuffers are main text windows, TextGrids are used mainly for\n"
"# status bars and such.\n"
"\n"
"gamma         1.0             # this affects text rendering, not other colors\n"
"\n"
"caretshape    2               # 0=smalldot 1=fatdot 2=thinline 3=fatline 4=block\n"
"linkstyle     1               # 1=underline hyperlinks 0=don't underline hyperlinks\n"
"\n"
"# moreprompt  ( more )\n"
"# morealign   0               # 0=left 1=center 2=right\n"
"# morefont    propb\n"
"\n"
"windowcolor   ffffff          # overall window background color\n"
"bordercolor   000000          # border line color\n"
"caretcolor    000000          # input caret color\n"
"linkcolor     000060          # hyperlink color\n"
"morecolor     006000          # more prompt color\n"
"\n"
"# Colors for text buffer windows\n"
"tcolor  0     000000  ffffff  # Normal\n"
"tcolor  1     000000  ffffff  # Emphasized\n"
"tcolor  2     000000  ffffff  # Preformatted\n"
"tcolor  3     000000  ffffff  # Header\n"
"tcolor  4     000000  ffffff  # Subheader\n"
"tcolor  5     000000  ffffff  # Alert\n"
"tcolor  6     000000  ffffff  # Note\n"
"tcolor  7     000000  ffffff  # BlockQuote\n"
"tcolor  8     006000  ffffff  # Input\n"
"tcolor  9     000000  ffffff  # User1\n"
"tcolor 10     000000  ffffff  # User2\n"
"\n"
"# Colors for text grid windows\n"
"gcolor  0     606060  ffffff  # Normal\n"
"gcolor  1     606060  ffffff  # Emphasized\n"
"gcolor  2     606060  ffffff  # Preformatted\n"
"gcolor  3     606060  ffffff  # Header\n"
"gcolor  4     606060  ffffff  # Subheader\n"
"gcolor  5     606060  ffffff  # Alert\n"
"gcolor  6     606060  ffffff  # Note\n"
"gcolor  7     606060  ffffff  # BlockQuote\n"
"gcolor  8     606060  ffffff  # Input\n"
"gcolor  9     606060  ffffff  # User1\n"
"gcolor 10     606060  ffffff  # User2\n"
"\n"
"# Instead of needing to specify individual colors, Gargoyle supports the concept\n"
"# of color themes, which set all possible colors at once. There are two\n"
"# hard-coded themes: \"light\" and \"dark\". In addition, there is a pseudo theme\n"
"# called \"system\" which attempts to follow the system theme, setting a dark or\n"
"# light theme as appropriate.\n"
"# Gargoyle also comes with several other themes, and you can provide your own\n"
"# themes as well. To see a list of available themes, use Shift-Control-T while\n"
"# Gargoyle is running. To see a list of theme paths (where you can add your own\n"
"# themes), use Control-period. MacOS users subtitute Command for Control.\n"
"# This must come after all other color settings, or they will override the theme.\n"
"# See THEMES.md for information on how themes are created.\n"
"theme system\n"
"\n"
"#===============================================================================\n"
"# Text-to-speech (TTS)\n"
"#-------------------------------------------------------------------------------\n"
"#\n"
"# Gargoyle can be built with text-to-speech capability. If so, the\n"
"# following options control it.\n"
"\n"
"speak            0           # 1=enable TTS, 0=disable TTS\n"
"\n"
"# The following apply only if TTS is enabled.\n"
"# speak_input    0           # 1=speak input the player types, 0=don't speak input\n"
"\n"
"# speak_language en          # if supported by the TTS engine, the language used\n"
"                             # for synthesis, as described by RFC 1766. Currently\n"
"                             # supported on OS X, and Unix with speech-dispatcher.\n"
"\n"
"\n"
"#===============================================================================\n"
"# You can add sections here to over-ride settings. List all the executables to\n"
"# be affected in the [ selector list ]. The name of game file can also be used\n"
"#-------------------------------------------------------------------------------\n"
"\n"
"[ trinity.z4 ]\n"
"mincols       62              # Trinity requires at least 62 columns\n"
"\n"
"[ winter.z5 ]\n"
"mincols       78\n"
"minrows       26              # Winter Wonderland contains ASCII art\n"
"\n"
"\n"
"#===============================================================================\n"
"# You can specify the default interpreter for game types. List all extensions to\n"
"# be affected in the [ selector list ]. The name of a game file can also be used\n"
"#-------------------------------------------------------------------------------\n"
"\n"
"# Zcode game types\n"
"# [ *.z3 *.z4 *.z5 *.z6 *.z7 *.z8 *.zlb *.zblorb ]\n"
"# terp bocfel\n"
"\n"
"# Glulx game types\n"
"# [ *.ulx *.blorb *.glb *.gblorb ]\n"
"# terp git\n"
"\n"
"# Superglus games require Glulxe\n"
"# [ *.blb ]\n"
"# terp glulxe\n"
"\n"
"# Override for specific game\n"
"# [ Floatpoint.zblorb ]\n"
"# terp glulxe\n"
"";
