/** \file
 * \brief RegisteredMultiArray for the usual GraphArray classes. TODO should be moved to a central location.
 *
 * \author Simon D. Fink <ogdf@niko.fink.bayern>
 *
 * \par License:
 * This file is part of the Open Graph Drawing Framework (OGDF).
 *
 * \par
 * Copyright (C)<br>
 * See README.md in the OGDF root directory for details.
 *
 * \par
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * Version 2 or 3 as published by the Free Software Foundation;
 * see the file LICENSE.txt included in the packaging of this file
 * for details.
 *
 * \par
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * \par
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, see
 * http://www.gnu.org/copyleft/gpl.html
 */
#pragma once

#include <ogdf/basic/Graph.h>
#include <ogdf/cluster/sync_plan/basic/RegisteredMultiArray.h>

namespace ogdf {

namespace internal {
template<typename T>
using NA = NodeArray<T, true>;
template<typename T>
using EA = EdgeArray<T, true>;
template<typename T>
using AEA = AdjEntryArray<T, true>;
}

template<typename Key2, typename Value>
using NodeMultiArray = RegisteredMultiArray<node, Key2, Value, internal::NA>;
template<typename Key2, typename Value>
using EdgeMultiArray = RegisteredMultiArray<edge, Key2, Value, internal::EA>;
template<typename Key2, typename Value>
using AdjEntryMultiArray = RegisteredMultiArray<adjEntry, Key2, Value, internal::AEA>;

}
