/*
 * © 2024 Zander Brown <zbrown@gnome.org>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * Values are derrived from ‘xpm-color-table.h’ from gdk-pixbuf, which was in
 * turn generated from rgb.txt at Sat Apr 6 06:45:32 2013.
 */

#pragma once

#include <stdint.h>

typedef struct {
  uint16_t red;
  uint16_t green;
  uint16_t blue;
} XpmColour;


typedef struct {
  char *name;
  XpmColour colour;
} XpmNamedColour;


static const XpmNamedColour xpm_colour_table[] = {
  { "aliceblue", { 61680, 63736, 65535 } },
  { "antiquewhite", { 64250, 60395, 55255 } },
  { "antiquewhite1", { 65535, 61423, 56283 } },
  { "antiquewhite2", { 61166, 57311, 52428 } },
  { "antiquewhite3", { 52685, 49344, 45232 } },
  { "antiquewhite4", { 35723, 33667, 30840 } },
  { "aqua", { 0, 65535, 65535 } },
  { "aquamarine", { 32639, 65535, 54484 } },
  { "aquamarine1", { 32639, 65535, 54484 } },
  { "aquamarine2", { 30326, 61166, 50886 } },
  { "aquamarine3", { 26214, 52685, 43690 } },
  { "aquamarine4", { 17733, 35723, 29812 } },
  { "azure", { 61680, 65535, 65535 } },
  { "azure1", { 61680, 65535, 65535 } },
  { "azure2", { 57568, 61166, 61166 } },
  { "azure3", { 49601, 52685, 52685 } },
  { "azure4", { 33667, 35723, 35723 } },
  { "beige", { 62965, 62965, 56540 } },
  { "bisque", { 65535, 58596, 50372 } },
  { "bisque1", { 65535, 58596, 50372 } },
  { "bisque2", { 61166, 54741, 47031 } },
  { "bisque3", { 52685, 47031, 40606 } },
  { "bisque4", { 35723, 32125, 27499 } },
  { "black", { 0, 0, 0 } },
  { "blanchedalmond", { 65535, 60395, 52685 } },
  { "blue", { 0, 0, 65535 } },
  { "blue1", { 0, 0, 65535 } },
  { "blue2", { 0, 0, 61166 } },
  { "blue3", { 0, 0, 52685 } },
  { "blue4", { 0, 0, 35723 } },
  { "blueviolet", { 35466, 11051, 58082 } },
  { "brown", { 42405, 10794, 10794 } },
  { "brown1", { 65535, 16448, 16448 } },
  { "brown2", { 61166, 15163, 15163 } },
  { "brown3", { 52685, 13107, 13107 } },
  { "brown4", { 35723, 8995, 8995 } },
  { "burlywood", { 57054, 47288, 34695 } },
  { "burlywood1", { 65535, 54227, 39835 } },
  { "burlywood2", { 61166, 50629, 37265 } },
  { "burlywood3", { 52685, 43690, 32125 } },
  { "burlywood4", { 35723, 29555, 21845 } },
  { "cadetblue", { 24415, 40606, 41120 } },
  { "cadetblue1", { 39064, 62965, 65535 } },
  { "cadetblue2", { 36494, 58853, 61166 } },
  { "cadetblue3", { 31354, 50629, 52685 } },
  { "cadetblue4", { 21331, 34438, 35723 } },
  { "chartreuse", { 32639, 65535, 0 } },
  { "chartreuse1", { 32639, 65535, 0 } },
  { "chartreuse2", { 30326, 61166, 0 } },
  { "chartreuse3", { 26214, 52685, 0 } },
  { "chartreuse4", { 17733, 35723, 0 } },
  { "chocolate", { 53970, 26985, 7710 } },
  { "chocolate1", { 65535, 32639, 9252 } },
  { "chocolate2", { 61166, 30326, 8481 } },
  { "chocolate3", { 52685, 26214, 7453 } },
  { "chocolate4", { 35723, 17733, 4883 } },
  { "coral", { 65535, 32639, 20560 } },
  { "coral1", { 65535, 29298, 22102 } },
  { "coral2", { 61166, 27242, 20560 } },
  { "coral3", { 52685, 23387, 17733 } },
  { "coral4", { 35723, 15934, 12079 } },
  { "cornflowerblue", { 25700, 38293, 60909 } },
  { "cornsilk", { 65535, 63736, 56540 } },
  { "cornsilk1", { 65535, 63736, 56540 } },
  { "cornsilk2", { 61166, 59624, 52685 } },
  { "cornsilk3", { 52685, 51400, 45489 } },
  { "cornsilk4", { 35723, 34952, 30840 } },
  { "crimson", { 56540, 5140, 15420 } },
  { "cyan", { 0, 65535, 65535 } },
  { "cyan1", { 0, 65535, 65535 } },
  { "cyan2", { 0, 61166, 61166 } },
  { "cyan3", { 0, 52685, 52685 } },
  { "cyan4", { 0, 35723, 35723 } },
  { "darkblue", { 0, 0, 35723 } },
  { "darkcyan", { 0, 35723, 35723 } },
  { "darkgoldenrod", { 47288, 34438, 2827 } },
  { "darkgoldenrod1", { 65535, 47545, 3855 } },
  { "darkgoldenrod2", { 61166, 44461, 3598 } },
  { "darkgoldenrod3", { 52685, 38293, 3084 } },
  { "darkgoldenrod4", { 35723, 25957, 2056 } },
  { "darkgray", { 43433, 43433, 43433 } },
  { "darkgreen", { 0, 25700, 0 } },
  { "darkgrey", { 43433, 43433, 43433 } },
  { "darkkhaki", { 48573, 47031, 27499 } },
  { "darkmagenta", { 35723, 0, 35723 } },
  { "darkolivegreen", { 21845, 27499, 12079 } },
  { "darkolivegreen1", { 51914, 65535, 28784 } },
  { "darkolivegreen2", { 48316, 61166, 26728 } },
  { "darkolivegreen3", { 41634, 52685, 23130 } },
  { "darkolivegreen4", { 28270, 35723, 15677 } },
  { "darkorange", { 65535, 35980, 0 } },
  { "darkorange1", { 65535, 32639, 0 } },
  { "darkorange2", { 61166, 30326, 0 } },
  { "darkorange3", { 52685, 26214, 0 } },
  { "darkorange4", { 35723, 17733, 0 } },
  { "darkorchid", { 39321, 12850, 52428 } },
  { "darkorchid1", { 49087, 15934, 65535 } },
  { "darkorchid2", { 45746, 14906, 61166 } },
  { "darkorchid3", { 39578, 12850, 52685 } },
  { "darkorchid4", { 26728, 8738, 35723 } },
  { "darkred", { 35723, 0, 0 } },
  { "darksalmon", { 59881, 38550, 31354 } },
  { "darkseagreen", { 36751, 48316, 36751 } },
  { "darkseagreen1", { 49601, 65535, 49601 } },
  { "darkseagreen2", { 46260, 61166, 46260 } },
  { "darkseagreen3", { 39835, 52685, 39835 } },
  { "darkseagreen4", { 26985, 35723, 26985 } },
  { "darkslateblue", { 18504, 15677, 35723 } },
  { "darkslategray", { 12079, 20303, 20303 } },
  { "darkslategray1", { 38807, 65535, 65535 } },
  { "darkslategray2", { 36237, 61166, 61166 } },
  { "darkslategray3", { 31097, 52685, 52685 } },
  { "darkslategray4", { 21074, 35723, 35723 } },
  { "darkslategrey", { 12079, 20303, 20303 } },
  { "darkturquoise", { 0, 52942, 53713 } },
  { "darkviolet", { 38036, 0, 54227 } },
  { "deeppink", { 65535, 5140, 37779 } },
  { "deeppink1", { 65535, 5140, 37779 } },
  { "deeppink2", { 61166, 4626, 35209 } },
  { "deeppink3", { 52685, 4112, 30326 } },
  { "deeppink4", { 35723, 2570, 20560 } },
  { "deepskyblue", { 0, 49087, 65535 } },
  { "deepskyblue1", { 0, 49087, 65535 } },
  { "deepskyblue2", { 0, 45746, 61166 } },
  { "deepskyblue3", { 0, 39578, 52685 } },
  { "deepskyblue4", { 0, 26728, 35723 } },
  { "dimgray", { 26985, 26985, 26985 } },
  { "dimgrey", { 26985, 26985, 26985 } },
  { "dodgerblue", { 7710, 37008, 65535 } },
  { "dodgerblue1", { 7710, 37008, 65535 } },
  { "dodgerblue2", { 7196, 34438, 61166 } },
  { "dodgerblue3", { 6168, 29812, 52685 } },
  { "dodgerblue4", { 4112, 20046, 35723 } },
  { "firebrick", { 45746, 8738, 8738 } },
  { "firebrick1", { 65535, 12336, 12336 } },
  { "firebrick2", { 61166, 11308, 11308 } },
  { "firebrick3", { 52685, 9766, 9766 } },
  { "firebrick4", { 35723, 6682, 6682 } },
  { "floralwhite", { 65535, 64250, 61680 } },
  { "forestgreen", { 8738, 35723, 8738 } },
  { "fuchsia", { 65535, 0, 65535 } },
  { "gainsboro", { 56540, 56540, 56540 } },
  { "ghostwhite", { 63736, 63736, 65535 } },
  { "gold", { 65535, 55255, 0 } },
  { "gold1", { 65535, 55255, 0 } },
  { "gold2", { 61166, 51657, 0 } },
  { "gold3", { 52685, 44461, 0 } },
  { "gold4", { 35723, 30069, 0 } },
  { "goldenrod", { 56026, 42405, 8224 } },
  { "goldenrod1", { 65535, 49601, 9509 } },
  { "goldenrod2", { 61166, 46260, 8738 } },
  { "goldenrod3", { 52685, 39835, 7453 } },
  { "goldenrod4", { 35723, 26985, 5140 } },
  { "gray", { 32896, 32896, 32896 } },
  { "gray0", { 0, 0, 0 } },
  { "gray1", { 771, 771, 771 } },
  { "gray10", { 6682, 6682, 6682 } },
  { "gray100", { 65535, 65535, 65535 } },
  { "gray11", { 7196, 7196, 7196 } },
  { "gray12", { 7967, 7967, 7967 } },
  { "gray13", { 8481, 8481, 8481 } },
  { "gray14", { 9252, 9252, 9252 } },
  { "gray15", { 9766, 9766, 9766 } },
  { "gray16", { 10537, 10537, 10537 } },
  { "gray17", { 11051, 11051, 11051 } },
  { "gray18", { 11822, 11822, 11822 } },
  { "gray19", { 12336, 12336, 12336 } },
  { "gray2", { 1285, 1285, 1285 } },
  { "gray20", { 13107, 13107, 13107 } },
  { "gray21", { 13878, 13878, 13878 } },
  { "gray22", { 14392, 14392, 14392 } },
  { "gray23", { 15163, 15163, 15163 } },
  { "gray24", { 15677, 15677, 15677 } },
  { "gray25", { 16448, 16448, 16448 } },
  { "gray26", { 16962, 16962, 16962 } },
  { "gray27", { 17733, 17733, 17733 } },
  { "gray28", { 18247, 18247, 18247 } },
  { "gray29", { 19018, 19018, 19018 } },
  { "gray3", { 2056, 2056, 2056 } },
  { "gray30", { 19789, 19789, 19789 } },
  { "gray31", { 20303, 20303, 20303 } },
  { "gray32", { 21074, 21074, 21074 } },
  { "gray33", { 21588, 21588, 21588 } },
  { "gray34", { 22359, 22359, 22359 } },
  { "gray35", { 22873, 22873, 22873 } },
  { "gray36", { 23644, 23644, 23644 } },
  { "gray37", { 24158, 24158, 24158 } },
  { "gray38", { 24929, 24929, 24929 } },
  { "gray39", { 25443, 25443, 25443 } },
  { "gray4", { 2570, 2570, 2570 } },
  { "gray40", { 26214, 26214, 26214 } },
  { "gray41", { 26985, 26985, 26985 } },
  { "gray42", { 27499, 27499, 27499 } },
  { "gray43", { 28270, 28270, 28270 } },
  { "gray44", { 28784, 28784, 28784 } },
  { "gray45", { 29555, 29555, 29555 } },
  { "gray46", { 30069, 30069, 30069 } },
  { "gray47", { 30840, 30840, 30840 } },
  { "gray48", { 31354, 31354, 31354 } },
  { "gray49", { 32125, 32125, 32125 } },
  { "gray5", { 3341, 3341, 3341 } },
  { "gray50", { 32639, 32639, 32639 } },
  { "gray51", { 33410, 33410, 33410 } },
  { "gray52", { 34181, 34181, 34181 } },
  { "gray53", { 34695, 34695, 34695 } },
  { "gray54", { 35466, 35466, 35466 } },
  { "gray55", { 35980, 35980, 35980 } },
  { "gray56", { 36751, 36751, 36751 } },
  { "gray57", { 37265, 37265, 37265 } },
  { "gray58", { 38036, 38036, 38036 } },
  { "gray59", { 38550, 38550, 38550 } },
  { "gray6", { 3855, 3855, 3855 } },
  { "gray60", { 39321, 39321, 39321 } },
  { "gray61", { 40092, 40092, 40092 } },
  { "gray62", { 40606, 40606, 40606 } },
  { "gray63", { 41377, 41377, 41377 } },
  { "gray64", { 41891, 41891, 41891 } },
  { "gray65", { 42662, 42662, 42662 } },
  { "gray66", { 43176, 43176, 43176 } },
  { "gray67", { 43947, 43947, 43947 } },
  { "gray68", { 44461, 44461, 44461 } },
  { "gray69", { 45232, 45232, 45232 } },
  { "gray7", { 4626, 4626, 4626 } },
  { "gray70", { 46003, 46003, 46003 } },
  { "gray71", { 46517, 46517, 46517 } },
  { "gray72", { 47288, 47288, 47288 } },
  { "gray73", { 47802, 47802, 47802 } },
  { "gray74", { 48573, 48573, 48573 } },
  { "gray75", { 49087, 49087, 49087 } },
  { "gray76", { 49858, 49858, 49858 } },
  { "gray77", { 50372, 50372, 50372 } },
  { "gray78", { 51143, 51143, 51143 } },
  { "gray79", { 51657, 51657, 51657 } },
  { "gray8", { 5140, 5140, 5140 } },
  { "gray80", { 52428, 52428, 52428 } },
  { "gray81", { 53199, 53199, 53199 } },
  { "gray82", { 53713, 53713, 53713 } },
  { "gray83", { 54484, 54484, 54484 } },
  { "gray84", { 54998, 54998, 54998 } },
  { "gray85", { 55769, 55769, 55769 } },
  { "gray86", { 56283, 56283, 56283 } },
  { "gray87", { 57054, 57054, 57054 } },
  { "gray88", { 57568, 57568, 57568 } },
  { "gray89", { 58339, 58339, 58339 } },
  { "gray9", { 5911, 5911, 5911 } },
  { "gray90", { 58853, 58853, 58853 } },
  { "gray91", { 59624, 59624, 59624 } },
  { "gray92", { 60395, 60395, 60395 } },
  { "gray93", { 60909, 60909, 60909 } },
  { "gray94", { 61680, 61680, 61680 } },
  { "gray95", { 62194, 62194, 62194 } },
  { "gray96", { 62965, 62965, 62965 } },
  { "gray97", { 63479, 63479, 63479 } },
  { "gray98", { 64250, 64250, 64250 } },
  { "gray99", { 64764, 64764, 64764 } },
  { "green", { 0, 32896, 0 } },
  { "green1", { 0, 65535, 0 } },
  { "green2", { 0, 61166, 0 } },
  { "green3", { 0, 52685, 0 } },
  { "green4", { 0, 35723, 0 } },
  { "greenyellow", { 44461, 65535, 12079 } },
  { "grey", { 32896, 32896, 32896 } },
  { "grey0", { 0, 0, 0 } },
  { "grey1", { 771, 771, 771 } },
  { "grey10", { 6682, 6682, 6682 } },
  { "grey100", { 65535, 65535, 65535 } },
  { "grey11", { 7196, 7196, 7196 } },
  { "grey12", { 7967, 7967, 7967 } },
  { "grey13", { 8481, 8481, 8481 } },
  { "grey14", { 9252, 9252, 9252 } },
  { "grey15", { 9766, 9766, 9766 } },
  { "grey16", { 10537, 10537, 10537 } },
  { "grey17", { 11051, 11051, 11051 } },
  { "grey18", { 11822, 11822, 11822 } },
  { "grey19", { 12336, 12336, 12336 } },
  { "grey2", { 1285, 1285, 1285 } },
  { "grey20", { 13107, 13107, 13107 } },
  { "grey21", { 13878, 13878, 13878 } },
  { "grey22", { 14392, 14392, 14392 } },
  { "grey23", { 15163, 15163, 15163 } },
  { "grey24", { 15677, 15677, 15677 } },
  { "grey25", { 16448, 16448, 16448 } },
  { "grey26", { 16962, 16962, 16962 } },
  { "grey27", { 17733, 17733, 17733 } },
  { "grey28", { 18247, 18247, 18247 } },
  { "grey29", { 19018, 19018, 19018 } },
  { "grey3", { 2056, 2056, 2056 } },
  { "grey30", { 19789, 19789, 19789 } },
  { "grey31", { 20303, 20303, 20303 } },
  { "grey32", { 21074, 21074, 21074 } },
  { "grey33", { 21588, 21588, 21588 } },
  { "grey34", { 22359, 22359, 22359 } },
  { "grey35", { 22873, 22873, 22873 } },
  { "grey36", { 23644, 23644, 23644 } },
  { "grey37", { 24158, 24158, 24158 } },
  { "grey38", { 24929, 24929, 24929 } },
  { "grey39", { 25443, 25443, 25443 } },
  { "grey4", { 2570, 2570, 2570 } },
  { "grey40", { 26214, 26214, 26214 } },
  { "grey41", { 26985, 26985, 26985 } },
  { "grey42", { 27499, 27499, 27499 } },
  { "grey43", { 28270, 28270, 28270 } },
  { "grey44", { 28784, 28784, 28784 } },
  { "grey45", { 29555, 29555, 29555 } },
  { "grey46", { 30069, 30069, 30069 } },
  { "grey47", { 30840, 30840, 30840 } },
  { "grey48", { 31354, 31354, 31354 } },
  { "grey49", { 32125, 32125, 32125 } },
  { "grey5", { 3341, 3341, 3341 } },
  { "grey50", { 32639, 32639, 32639 } },
  { "grey51", { 33410, 33410, 33410 } },
  { "grey52", { 34181, 34181, 34181 } },
  { "grey53", { 34695, 34695, 34695 } },
  { "grey54", { 35466, 35466, 35466 } },
  { "grey55", { 35980, 35980, 35980 } },
  { "grey56", { 36751, 36751, 36751 } },
  { "grey57", { 37265, 37265, 37265 } },
  { "grey58", { 38036, 38036, 38036 } },
  { "grey59", { 38550, 38550, 38550 } },
  { "grey6", { 3855, 3855, 3855 } },
  { "grey60", { 39321, 39321, 39321 } },
  { "grey61", { 40092, 40092, 40092 } },
  { "grey62", { 40606, 40606, 40606 } },
  { "grey63", { 41377, 41377, 41377 } },
  { "grey64", { 41891, 41891, 41891 } },
  { "grey65", { 42662, 42662, 42662 } },
  { "grey66", { 43176, 43176, 43176 } },
  { "grey67", { 43947, 43947, 43947 } },
  { "grey68", { 44461, 44461, 44461 } },
  { "grey69", { 45232, 45232, 45232 } },
  { "grey7", { 4626, 4626, 4626 } },
  { "grey70", { 46003, 46003, 46003 } },
  { "grey71", { 46517, 46517, 46517 } },
  { "grey72", { 47288, 47288, 47288 } },
  { "grey73", { 47802, 47802, 47802 } },
  { "grey74", { 48573, 48573, 48573 } },
  { "grey75", { 49087, 49087, 49087 } },
  { "grey76", { 49858, 49858, 49858 } },
  { "grey77", { 50372, 50372, 50372 } },
  { "grey78", { 51143, 51143, 51143 } },
  { "grey79", { 51657, 51657, 51657 } },
  { "grey8", { 5140, 5140, 5140 } },
  { "grey80", { 52428, 52428, 52428 } },
  { "grey81", { 53199, 53199, 53199 } },
  { "grey82", { 53713, 53713, 53713 } },
  { "grey83", { 54484, 54484, 54484 } },
  { "grey84", { 54998, 54998, 54998 } },
  { "grey85", { 55769, 55769, 55769 } },
  { "grey86", { 56283, 56283, 56283 } },
  { "grey87", { 57054, 57054, 57054 } },
  { "grey88", { 57568, 57568, 57568 } },
  { "grey89", { 58339, 58339, 58339 } },
  { "grey9", { 5911, 5911, 5911 } },
  { "grey90", { 58853, 58853, 58853 } },
  { "grey91", { 59624, 59624, 59624 } },
  { "grey92", { 60395, 60395, 60395 } },
  { "grey93", { 60909, 60909, 60909 } },
  { "grey94", { 61680, 61680, 61680 } },
  { "grey95", { 62194, 62194, 62194 } },
  { "grey96", { 62965, 62965, 62965 } },
  { "grey97", { 63479, 63479, 63479 } },
  { "grey98", { 64250, 64250, 64250 } },
  { "grey99", { 64764, 64764, 64764 } },
  { "honeydew", { 61680, 65535, 61680 } },
  { "honeydew1", { 61680, 65535, 61680 } },
  { "honeydew2", { 57568, 61166, 57568 } },
  { "honeydew3", { 49601, 52685, 49601 } },
  { "honeydew4", { 33667, 35723, 33667 } },
  { "hotpink", { 65535, 26985, 46260 } },
  { "hotpink1", { 65535, 28270, 46260 } },
  { "hotpink2", { 61166, 27242, 42919 } },
  { "hotpink3", { 52685, 24672, 37008 } },
  { "hotpink4", { 35723, 14906, 25186 } },
  { "indianred", { 52685, 23644, 23644 } },
  { "indianred1", { 65535, 27242, 27242 } },
  { "indianred2", { 61166, 25443, 25443 } },
  { "indianred3", { 52685, 21845, 21845 } },
  { "indianred4", { 35723, 14906, 14906 } },
  { "indigo", { 19275, 0, 33410 } },
  { "ivory", { 65535, 65535, 61680 } },
  { "ivory1", { 65535, 65535, 61680 } },
  { "ivory2", { 61166, 61166, 57568 } },
  { "ivory3", { 52685, 52685, 49601 } },
  { "ivory4", { 35723, 35723, 33667 } },
  { "khaki", { 61680, 59110, 35980 } },
  { "khaki1", { 65535, 63222, 36751 } },
  { "khaki2", { 61166, 59110, 34181 } },
  { "khaki3", { 52685, 50886, 29555 } },
  { "khaki4", { 35723, 34438, 20046 } },
  { "lavender", { 59110, 59110, 64250 } },
  { "lavenderblush", { 65535, 61680, 62965 } },
  { "lavenderblush1", { 65535, 61680, 62965 } },
  { "lavenderblush2", { 61166, 57568, 58853 } },
  { "lavenderblush3", { 52685, 49601, 50629 } },
  { "lavenderblush4", { 35723, 33667, 34438 } },
  { "lawngreen", { 31868, 64764, 0 } },
  { "lemonchiffon", { 65535, 64250, 52685 } },
  { "lemonchiffon1", { 65535, 64250, 52685 } },
  { "lemonchiffon2", { 61166, 59881, 49087 } },
  { "lemonchiffon3", { 52685, 51657, 42405 } },
  { "lemonchiffon4", { 35723, 35209, 28784 } },
  { "lightblue", { 44461, 55512, 59110 } },
  { "lightblue1", { 49087, 61423, 65535 } },
  { "lightblue2", { 45746, 57311, 61166 } },
  { "lightblue3", { 39578, 49344, 52685 } },
  { "lightblue4", { 26728, 33667, 35723 } },
  { "lightcoral", { 61680, 32896, 32896 } },
  { "lightcyan", { 57568, 65535, 65535 } },
  { "lightcyan1", { 57568, 65535, 65535 } },
  { "lightcyan2", { 53713, 61166, 61166 } },
  { "lightcyan3", { 46260, 52685, 52685 } },
  { "lightcyan4", { 31354, 35723, 35723 } },
  { "lightgoldenrod", { 61166, 56797, 33410 } },
  { "lightgoldenrod1", { 65535, 60652, 35723 } },
  { "lightgoldenrod2", { 61166, 56540, 33410 } },
  { "lightgoldenrod3", { 52685, 48830, 28784 } },
  { "lightgoldenrod4", { 35723, 33153, 19532 } },
  { "lightgoldenrodyellow", { 64250, 64250, 53970 } },
  { "lightgray", { 54227, 54227, 54227 } },
  { "lightgreen", { 37008, 61166, 37008 } },
  { "lightgrey", { 54227, 54227, 54227 } },
  { "lightpink", { 65535, 46774, 49601 } },
  { "lightpink1", { 65535, 44718, 47545 } },
  { "lightpink2", { 61166, 41634, 44461 } },
  { "lightpink3", { 52685, 35980, 38293 } },
  { "lightpink4", { 35723, 24415, 25957 } },
  { "lightsalmon", { 65535, 41120, 31354 } },
  { "lightsalmon1", { 65535, 41120, 31354 } },
  { "lightsalmon2", { 61166, 38293, 29298 } },
  { "lightsalmon3", { 52685, 33153, 25186 } },
  { "lightsalmon4", { 35723, 22359, 16962 } },
  { "lightseagreen", { 8224, 45746, 43690 } },
  { "lightskyblue", { 34695, 52942, 64250 } },
  { "lightskyblue1", { 45232, 58082, 65535 } },
  { "lightskyblue2", { 42148, 54227, 61166 } },
  { "lightskyblue3", { 36237, 46774, 52685 } },
  { "lightskyblue4", { 24672, 31611, 35723 } },
  { "lightslateblue", { 33924, 28784, 65535 } },
  { "lightslategray", { 30583, 34952, 39321 } },
  { "lightslategrey", { 30583, 34952, 39321 } },
  { "lightsteelblue", { 45232, 50372, 57054 } },
  { "lightsteelblue1", { 51914, 57825, 65535 } },
  { "lightsteelblue2", { 48316, 53970, 61166 } },
  { "lightsteelblue3", { 41634, 46517, 52685 } },
  { "lightsteelblue4", { 28270, 31611, 35723 } },
  { "lightyellow", { 65535, 65535, 57568 } },
  { "lightyellow1", { 65535, 65535, 57568 } },
  { "lightyellow2", { 61166, 61166, 53713 } },
  { "lightyellow3", { 52685, 52685, 46260 } },
  { "lightyellow4", { 35723, 35723, 31354 } },
  { "lime", { 0, 65535, 0 } },
  { "limegreen", { 12850, 52685, 12850 } },
  { "linen", { 64250, 61680, 59110 } },
  { "magenta", { 65535, 0, 65535 } },
  { "magenta1", { 65535, 0, 65535 } },
  { "magenta2", { 61166, 0, 61166 } },
  { "magenta3", { 52685, 0, 52685 } },
  { "magenta4", { 35723, 0, 35723 } },
  { "maroon", { 32896, 0, 0 } },
  { "maroon1", { 65535, 13364, 46003 } },
  { "maroon2", { 61166, 12336, 42919 } },
  { "maroon3", { 52685, 10537, 37008 } },
  { "maroon4", { 35723, 7196, 25186 } },
  { "mediumaquamarine", { 26214, 52685, 43690 } },
  { "mediumblue", { 0, 0, 52685 } },
  { "mediumorchid", { 47802, 21845, 54227 } },
  { "mediumorchid1", { 57568, 26214, 65535 } },
  { "mediumorchid2", { 53713, 24415, 61166 } },
  { "mediumorchid3", { 46260, 21074, 52685 } },
  { "mediumorchid4", { 31354, 14135, 35723 } },
  { "mediumpurple", { 37779, 28784, 56283 } },
  { "mediumpurple1", { 43947, 33410, 65535 } },
  { "mediumpurple2", { 40863, 31097, 61166 } },
  { "mediumpurple3", { 35209, 26728, 52685 } },
  { "mediumpurple4", { 23901, 18247, 35723 } },
  { "mediumseagreen", { 15420, 46003, 29041 } },
  { "mediumslateblue", { 31611, 26728, 61166 } },
  { "mediumspringgreen", { 0, 64250, 39578 } },
  { "mediumturquoise", { 18504, 53713, 52428 } },
  { "mediumvioletred", { 51143, 5397, 34181 } },
  { "midnightblue", { 6425, 6425, 28784 } },
  { "mintcream", { 62965, 65535, 64250 } },
  { "mistyrose", { 65535, 58596, 57825 } },
  { "mistyrose1", { 65535, 58596, 57825 } },
  { "mistyrose2", { 61166, 54741, 53970 } },
  { "mistyrose3", { 52685, 47031, 46517 } },
  { "mistyrose4", { 35723, 32125, 31611 } },
  { "moccasin", { 65535, 58596, 46517 } },
  { "navajowhite", { 65535, 57054, 44461 } },
  { "navajowhite1", { 65535, 57054, 44461 } },
  { "navajowhite2", { 61166, 53199, 41377 } },
  { "navajowhite3", { 52685, 46003, 35723 } },
  { "navajowhite4", { 35723, 31097, 24158 } },
  { "navy", { 0, 0, 32896 } },
  { "navyblue", { 0, 0, 32896 } },
  { "oldlace", { 65021, 62965, 59110 } },
  { "olive", { 32896, 32896, 0 } },
  { "olivedrab", { 27499, 36494, 8995 } },
  { "olivedrab1", { 49344, 65535, 15934 } },
  { "olivedrab2", { 46003, 61166, 14906 } },
  { "olivedrab3", { 39578, 52685, 12850 } },
  { "olivedrab4", { 26985, 35723, 8738 } },
  { "orange", { 65535, 42405, 0 } },
  { "orange1", { 65535, 42405, 0 } },
  { "orange2", { 61166, 39578, 0 } },
  { "orange3", { 52685, 34181, 0 } },
  { "orange4", { 35723, 23130, 0 } },
  { "orangered", { 65535, 17733, 0 } },
  { "orangered1", { 65535, 17733, 0 } },
  { "orangered2", { 61166, 16448, 0 } },
  { "orangered3", { 52685, 14135, 0 } },
  { "orangered4", { 35723, 9509, 0 } },
  { "orchid", { 56026, 28784, 54998 } },
  { "orchid1", { 65535, 33667, 64250 } },
  { "orchid2", { 61166, 31354, 59881 } },
  { "orchid3", { 52685, 26985, 51657 } },
  { "orchid4", { 35723, 18247, 35209 } },
  { "palegoldenrod", { 61166, 59624, 43690 } },
  { "palegreen", { 39064, 64507, 39064 } },
  { "palegreen1", { 39578, 65535, 39578 } },
  { "palegreen2", { 37008, 61166, 37008 } },
  { "palegreen3", { 31868, 52685, 31868 } },
  { "palegreen4", { 21588, 35723, 21588 } },
  { "paleturquoise", { 44975, 61166, 61166 } },
  { "paleturquoise1", { 48059, 65535, 65535 } },
  { "paleturquoise2", { 44718, 61166, 61166 } },
  { "paleturquoise3", { 38550, 52685, 52685 } },
  { "paleturquoise4", { 26214, 35723, 35723 } },
  { "palevioletred", { 56283, 28784, 37779 } },
  { "palevioletred1", { 65535, 33410, 43947 } },
  { "palevioletred2", { 61166, 31097, 40863 } },
  { "palevioletred3", { 52685, 26728, 35209 } },
  { "palevioletred4", { 35723, 18247, 23901 } },
  { "papayawhip", { 65535, 61423, 54741 } },
  { "peachpuff", { 65535, 56026, 47545 } },
  { "peachpuff1", { 65535, 56026, 47545 } },
  { "peachpuff2", { 61166, 52171, 44461 } },
  { "peachpuff3", { 52685, 44975, 38293 } },
  { "peachpuff4", { 35723, 30583, 25957 } },
  { "peru", { 52685, 34181, 16191 } },
  { "pink", { 65535, 49344, 52171 } },
  { "pink1", { 65535, 46517, 50629 } },
  { "pink2", { 61166, 43433, 47288 } },
  { "pink3", { 52685, 37265, 40606 } },
  { "pink4", { 35723, 25443, 27756 } },
  { "plum", { 56797, 41120, 56797 } },
  { "plum1", { 65535, 48059, 65535 } },
  { "plum2", { 61166, 44718, 61166 } },
  { "plum3", { 52685, 38550, 52685 } },
  { "plum4", { 35723, 26214, 35723 } },
  { "powderblue", { 45232, 57568, 59110 } },
  { "purple", { 32896, 0, 32896 } },
  { "purple1", { 39835, 12336, 65535 } },
  { "purple2", { 37265, 11308, 61166 } },
  { "purple3", { 32125, 9766, 52685 } },
  { "purple4", { 21845, 6682, 35723 } },
  { "red", { 65535, 0, 0 } },
  { "red1", { 65535, 0, 0 } },
  { "red2", { 61166, 0, 0 } },
  { "red3", { 52685, 0, 0 } },
  { "red4", { 35723, 0, 0 } },
  { "rosybrown", { 48316, 36751, 36751 } },
  { "rosybrown1", { 65535, 49601, 49601 } },
  { "rosybrown2", { 61166, 46260, 46260 } },
  { "rosybrown3", { 52685, 39835, 39835 } },
  { "rosybrown4", { 35723, 26985, 26985 } },
  { "royalblue", { 16705, 26985, 57825 } },
  { "royalblue1", { 18504, 30326, 65535 } },
  { "royalblue2", { 17219, 28270, 61166 } },
  { "royalblue3", { 14906, 24415, 52685 } },
  { "royalblue4", { 10023, 16448, 35723 } },
  { "saddlebrown", { 35723, 17733, 4883 } },
  { "salmon", { 64250, 32896, 29298 } },
  { "salmon1", { 65535, 35980, 26985 } },
  { "salmon2", { 61166, 33410, 25186 } },
  { "salmon3", { 52685, 28784, 21588 } },
  { "salmon4", { 35723, 19532, 14649 } },
  { "sandybrown", { 62708, 42148, 24672 } },
  { "seagreen", { 11822, 35723, 22359 } },
  { "seagreen1", { 21588, 65535, 40863 } },
  { "seagreen2", { 20046, 61166, 38036 } },
  { "seagreen3", { 17219, 52685, 32896 } },
  { "seagreen4", { 11822, 35723, 22359 } },
  { "seashell", { 65535, 62965, 61166 } },
  { "seashell1", { 65535, 62965, 61166 } },
  { "seashell2", { 61166, 58853, 57054 } },
  { "seashell3", { 52685, 50629, 49087 } },
  { "seashell4", { 35723, 34438, 33410 } },
  { "sienna", { 41120, 21074, 11565 } },
  { "sienna1", { 65535, 33410, 18247 } },
  { "sienna2", { 61166, 31097, 16962 } },
  { "sienna3", { 52685, 26728, 14649 } },
  { "sienna4", { 35723, 18247, 9766 } },
  { "silver", { 49344, 49344, 49344 } },
  { "skyblue", { 34695, 52942, 60395 } },
  { "skyblue1", { 34695, 52942, 65535 } },
  { "skyblue2", { 32382, 49344, 61166 } },
  { "skyblue3", { 27756, 42662, 52685 } },
  { "skyblue4", { 19018, 28784, 35723 } },
  { "slateblue", { 27242, 23130, 52685 } },
  { "slateblue1", { 33667, 28527, 65535 } },
  { "slateblue2", { 31354, 26471, 61166 } },
  { "slateblue3", { 26985, 22873, 52685 } },
  { "slateblue4", { 18247, 15420, 35723 } },
  { "slategray", { 28784, 32896, 37008 } },
  { "slategray1", { 50886, 58082, 65535 } },
  { "slategray2", { 47545, 54227, 61166 } },
  { "slategray3", { 40863, 46774, 52685 } },
  { "slategray4", { 27756, 31611, 35723 } },
  { "slategrey", { 28784, 32896, 37008 } },
  { "snow", { 65535, 64250, 64250 } },
  { "snow1", { 65535, 64250, 64250 } },
  { "snow2", { 61166, 59881, 59881 } },
  { "snow3", { 52685, 51657, 51657 } },
  { "snow4", { 35723, 35209, 35209 } },
  { "springgreen", { 0, 65535, 32639 } },
  { "springgreen1", { 0, 65535, 32639 } },
  { "springgreen2", { 0, 61166, 30326 } },
  { "springgreen3", { 0, 52685, 26214 } },
  { "springgreen4", { 0, 35723, 17733 } },
  { "steelblue", { 17990, 33410, 46260 } },
  { "steelblue1", { 25443, 47288, 65535 } },
  { "steelblue2", { 23644, 44204, 61166 } },
  { "steelblue3", { 20303, 38036, 52685 } },
  { "steelblue4", { 13878, 25700, 35723 } },
  { "tan", { 53970, 46260, 35980 } },
  { "tan1", { 65535, 42405, 20303 } },
  { "tan2", { 61166, 39578, 18761 } },
  { "tan3", { 52685, 34181, 16191 } },
  { "tan4", { 35723, 23130, 11051 } },
  { "teal", { 0, 32896, 32896 } },
  { "thistle", { 55512, 49087, 55512 } },
  { "thistle1", { 65535, 57825, 65535 } },
  { "thistle2", { 61166, 53970, 61166 } },
  { "thistle3", { 52685, 46517, 52685 } },
  { "thistle4", { 35723, 31611, 35723 } },
  { "tomato", { 65535, 25443, 18247 } },
  { "tomato1", { 65535, 25443, 18247 } },
  { "tomato2", { 61166, 23644, 16962 } },
  { "tomato3", { 52685, 20303, 14649 } },
  { "tomato4", { 35723, 13878, 9766 } },
  { "turquoise", { 16448, 57568, 53456 } },
  { "turquoise1", { 0, 62965, 65535 } },
  { "turquoise2", { 0, 58853, 61166 } },
  { "turquoise3", { 0, 50629, 52685 } },
  { "turquoise4", { 0, 34438, 35723 } },
  { "violet", { 61166, 33410, 61166 } },
  { "violetred", { 53456, 8224, 37008 } },
  { "violetred1", { 65535, 15934, 38550 } },
  { "violetred2", { 61166, 14906, 35980 } },
  { "violetred3", { 52685, 12850, 30840 } },
  { "violetred4", { 35723, 8738, 21074 } },
  { "wheat", { 62965, 57054, 46003 } },
  { "wheat1", { 65535, 59367, 47802 } },
  { "wheat2", { 61166, 55512, 44718 } },
  { "wheat3", { 52685, 47802, 38550 } },
  { "wheat4", { 35723, 32382, 26214 } },
  { "white", { 65535, 65535, 65535 } },
  { "whitesmoke", { 62965, 62965, 62965 } },
  { "yellow", { 65535, 65535, 0 } },
  { "yellow1", { 65535, 65535, 0 } },
  { "yellow2", { 61166, 61166, 0 } },
  { "yellow3", { 52685, 52685, 0 } },
  { "yellow4", { 35723, 35723, 0 } },
  { "yellowgreen", { 39578, 52685, 12850 } },
};


static int
check_name (const void *a, const void *b)
{
  return g_strcmp0 ((const char *) a, ((const XpmNamedColour *) b)->name);
}


static inline gboolean
xpm_colour_table_loopup (const char *const restrict name,
                         XpmColour  *const restrict colour)
{
  XpmNamedColour *found = bsearch (name,
                                   xpm_colour_table,
                                   G_N_ELEMENTS (xpm_colour_table),
                                   sizeof (XpmNamedColour),
                                   check_name);
  if (G_UNLIKELY (found == NULL))
    return FALSE;

  *colour = found->colour;

  return TRUE;
}
